<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsResourcesTable extends Migration {

	public function up()
	{
		Schema::create('items_resources', function(Blueprint $table) {
			$table->increments('id');
			$table->string('filename');
			$table->string('filesize');
			$table->integer('item_id')->unsigned();
			$table->timestamp('published_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('items_resources');
	}
}