<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Group extends Eloquent {

	protected $table = 'groups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function group()
	{
		return $this->hasMany('GroupUser');
	}

	public function group()
	{
		return $this->belongsTo('GroupParent');
	}

	public function groupsie()
	{
		return $this->hasMany('Group');
	}

	public function igroup()
	{
		return $this->hasOne('GroupInfo');
	}

	public function groupt()
	{
		return $this->hasOne('GroupType');
	}

	public function group_items()
	{
		return $this->hasMany('Item');
	}

}