<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('items_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('content_id')->references('id')->on('items_contents')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('items_comments', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('items_comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('items_contents', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('group_parent', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('group_site', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('group_site', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('group_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('group_user', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('items_resources', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('site_user', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('site_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sites', function(Blueprint $table) {
			$table->foreign('trust_id')->references('id')->on('trusts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('social_accounts', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('unique_id')->references('UPN')->on('upn_lookups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('group_infos', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('group_types', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('items_likes', function(Blueprint $table) {
			$table->foreign('items_id')->references('id')->on('items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('items_likes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('items_favourites', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('items_favourites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_notifications', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('passbanks', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('safeguarding_logs', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('safeguarding_logs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sessions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('upn_lookups', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('upn_lookups', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('devices', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('devices', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('logs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sites_slots', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sites_terms', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_group_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_user_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_category_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_content_id_foreign');
		});
		Schema::table('items_comments', function(Blueprint $table) {
			$table->dropForeign('items_comments_item_id_foreign');
		});
		Schema::table('items_comments', function(Blueprint $table) {
			$table->dropForeign('items_comments_user_id_foreign');
		});
		Schema::table('items_contents', function(Blueprint $table) {
			$table->dropForeign('items_contents_item_id_foreign');
		});
		Schema::table('group_parent', function(Blueprint $table) {
			$table->dropForeign('group_parent_group_id_foreign');
		});
		Schema::table('group_site', function(Blueprint $table) {
			$table->dropForeign('group_site_group_id_foreign');
		});
		Schema::table('group_site', function(Blueprint $table) {
			$table->dropForeign('group_site_site_id_foreign');
		});
		Schema::table('group_user', function(Blueprint $table) {
			$table->dropForeign('group_user_user_id_foreign');
		});
		Schema::table('group_user', function(Blueprint $table) {
			$table->dropForeign('group_user_group_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_permission_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_role_id_foreign');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_user_id_foreign');
		});
		Schema::table('items_resources', function(Blueprint $table) {
			$table->dropForeign('items_resources_item_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_role_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_user_id_foreign');
		});
		Schema::table('site_user', function(Blueprint $table) {
			$table->dropForeign('site_user_site_id_foreign');
		});
		Schema::table('site_user', function(Blueprint $table) {
			$table->dropForeign('site_user_user_id_foreign');
		});
		Schema::table('sites', function(Blueprint $table) {
			$table->dropForeign('sites_trust_id_foreign');
		});
		Schema::table('social_accounts', function(Blueprint $table) {
			$table->dropForeign('social_accounts_site_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_unique_id_foreign');
		});
		Schema::table('group_infos', function(Blueprint $table) {
			$table->dropForeign('group_infos_group_id_foreign');
		});
		Schema::table('group_types', function(Blueprint $table) {
			$table->dropForeign('group_types_group_id_foreign');
		});
		Schema::table('items_likes', function(Blueprint $table) {
			$table->dropForeign('items_likes_items_id_foreign');
		});
		Schema::table('items_likes', function(Blueprint $table) {
			$table->dropForeign('items_likes_user_id_foreign');
		});
		Schema::table('items_favourites', function(Blueprint $table) {
			$table->dropForeign('items_favourites_item_id_foreign');
		});
		Schema::table('items_favourites', function(Blueprint $table) {
			$table->dropForeign('items_favourites_user_id_foreign');
		});
		Schema::table('user_notifications', function(Blueprint $table) {
			$table->dropForeign('user_notifications_user_id_foreign');
		});
		Schema::table('user_notifications', function(Blueprint $table) {
			$table->dropForeign('user_notifications_item_id_foreign');
		});
		Schema::table('passbanks', function(Blueprint $table) {
			$table->dropForeign('passbanks_user_id_foreign');
		});
		Schema::table('safeguarding_logs', function(Blueprint $table) {
			$table->dropForeign('safeguarding_logs_site_id_foreign');
		});
		Schema::table('safeguarding_logs', function(Blueprint $table) {
			$table->dropForeign('safeguarding_logs_user_id_foreign');
		});
		Schema::table('sessions', function(Blueprint $table) {
			$table->dropForeign('sessions_user_id_foreign');
		});
		Schema::table('upn_lookups', function(Blueprint $table) {
			$table->dropForeign('upn_lookups_user_id_foreign');
		});
		Schema::table('upn_lookups', function(Blueprint $table) {
			$table->dropForeign('upn_lookups_group_id_foreign');
		});
		Schema::table('devices', function(Blueprint $table) {
			$table->dropForeign('devices_user_id_foreign');
		});
		Schema::table('devices', function(Blueprint $table) {
			$table->dropForeign('devices_site_id_foreign');
		});
		Schema::table('logs', function(Blueprint $table) {
			$table->dropForeign('logs_user_id_foreign');
		});
		Schema::table('sites_slots', function(Blueprint $table) {
			$table->dropForeign('sites_slots_site_id_foreign');
		});
		Schema::table('sites_terms', function(Blueprint $table) {
			$table->dropForeign('sites_terms_site_id_foreign');
		});
	}
}