<?php

namespace App\Models;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;
	protected $fillable = array('name', 'parent_id');

	public function files()
	{
		return $this->hasMany('App\Models\File');
	}

	public function parent()
	{
		return $this->belongsTo('App\Models\Category', 'parent_id');
	}

	public function children()
	{
		return $this->hasMany('App\Models\Category', 'parent_id');
	}

}