<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'discription', 'user_id', 'category_id', 'price');

	public function users()
	{
		return $this->belongsTo('App\User');
	}

	public function orders()
	{
		return $this->belongsToMany('App\Order');
	}

	public function categories()
	{
		return $this->belongsTo('App\Category');
	}

}