<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function products()
	{
		return $this->hasMany('App\Product');
	}

	public function roles()
	{
		return $this->belongsToMany('App\Role');
	}

}