<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Rate extends Eloquent {

	protected $table = 'rate';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'question1', 'question2', 'question3', 'question4', 'question5', 'review');

	public function order()
	{
		return $this->belongsTo('Order', 'order_id');
	}

}