<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->float('total_value')->nullable();
			$table->float('total_items')->nullable();
			$table->float('total_shipping')->nullable();
			$table->float('total_discounts')->nullable();
			$table->integer('status_id')->unsigned();
			$table->integer('customer_id');
			$table->integer('address_id');
			$table->string('delivery_type');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}