<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Date extends Model 
{

    protected $table = 'dates';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('event_id', 'date');

    public function events()
    {
        return $this->belongsTo('Event');
    }

    public function venues()
    {
        return $this->hasOne('Venue');
    }

}