<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUpsellVolumeDiscountsTable extends Migration {

	public function up()
	{
		Schema::create('upsell_volume_discounts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('upsell_id')->unsigned();
			$table->integer('quantity');
			$table->integer('discount');
			$table->string('discount_type', 191);
			$table->boolean('best_deal')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('upsell_volume_discounts');
	}
}