<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->tinyInteger('setup');
			$table->tinyInteger('enable');
			$table->string('language');
			$table->string('currency');
			$table->string('theme_id');
			$table->string('domain');
			$table->text('store_name');
			$table->text('store_email');
			$table->string('store_phone');
			$table->string('country_name');
			$table->string('plan_display_name', 191);
			$table->timestamp('last_updated');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}