<?php

namespace App\Models;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;
	protected $fillable = array('address', 'total', 'commission', 'payment_method', 'delivery_cost', 'cost', 'status', 'net', 'restaurant_id', 'client_id');

	public function clients()
	{
		return $this->belongsTo('App\Models\Client');
	}

	public function restaurant()
	{
		return $this->belongsTo('App\Models\Restaurant');
	}

	public function products()
	{
		return $this->hasMany('App\Models\Product');
	}

}