<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('directions', function(Blueprint $table) {
			$table->foreign('atelier_id')->references('id')->on('ateliers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('atelier_prospect', function(Blueprint $table) {
			$table->foreign('prospect_id')->references('id')->on('prospects')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('atelier_prospect', function(Blueprint $table) {
			$table->foreign('atelier_id')->references('id')->on('ateliers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('matieres', function(Blueprint $table) {
			$table->foreign('professeur_id')->references('id')->on('professeurs')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('lecons', function(Blueprint $table) {
			$table->foreign('achat_id')->references('id')->on('achats')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('lecons', function(Blueprint $table) {
			$table->foreign('horaire_id')->references('id')->on('horaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('honoraires', function(Blueprint $table) {
			$table->foreign('contrat_id')->references('id')->on('contrats')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contrats', function(Blueprint $table) {
			$table->foreign('matiere_id')->references('id')->on('matieres')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('honoraire_professeur', function(Blueprint $table) {
			$table->foreign('professeur_id')->references('id')->on('professeurs')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('honoraire_professeur', function(Blueprint $table) {
			$table->foreign('honoraire_id')->references('id')->on('honoraires')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('achats', function(Blueprint $table) {
			$table->foreign('forfait_id')->references('id')->on('forfaits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->foreign('professeur_id')->references('id')->on('professeurs')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('horaireable', function(Blueprint $table) {
			$table->foreign('horaire_id')->references('id')->on('horaires')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('matiereable', function(Blueprint $table) {
			$table->foreign('matiere_id')->references('id')->on('matieres')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('honoraireable', function(Blueprint $table) {
			$table->foreign('honoraire_id')->references('id')->on('honoraires')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('mediasable', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('medias')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('achat_eleve', function(Blueprint $table) {
			$table->foreign('eleve_id')->references('id')->on('eleves')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('achat_eleve', function(Blueprint $table) {
			$table->foreign('achat_id')->references('id')->on('achats')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('honoraire_facture', function(Blueprint $table) {
			$table->foreign('honoraire_id')->references('id')->on('honoraires')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('honoraire_facture', function(Blueprint $table) {
			$table->foreign('honoraire_facture_id')->references('id')->on('factures_professeurs')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('paiements', function(Blueprint $table) {
			$table->foreign('achat_id')->references('id')->on('achats')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('forfait_matiere', function(Blueprint $table) {
			$table->foreign('forfait_id')->references('id')->on('forfaits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('forfait_matiere', function(Blueprint $table) {
			$table->foreign('matiere_id')->references('id')->on('matieres')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('achat_horaire', function(Blueprint $table) {
			$table->foreign('achat_id')->references('id')->on('achats')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('achat_horaire', function(Blueprint $table) {
			$table->foreign('horaire_id')->references('id')->on('horaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('dates', function(Blueprint $table) {
			$table->foreign('matiere_id')->references('id')->on('matieres')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('directions', function(Blueprint $table) {
			$table->dropForeign('directions_atelier_id_foreign');
		});
		Schema::table('atelier_prospect', function(Blueprint $table) {
			$table->dropForeign('atelier_prospect_prospect_id_foreign');
		});
		Schema::table('atelier_prospect', function(Blueprint $table) {
			$table->dropForeign('atelier_prospect_atelier_id_foreign');
		});
		Schema::table('matieres', function(Blueprint $table) {
			$table->dropForeign('matieres_professeur_id_foreign');
		});
		Schema::table('lecons', function(Blueprint $table) {
			$table->dropForeign('lecons_achat_id_foreign');
		});
		Schema::table('lecons', function(Blueprint $table) {
			$table->dropForeign('lecons_horaire_id_foreign');
		});
		Schema::table('honoraires', function(Blueprint $table) {
			$table->dropForeign('honoraires_contrat_id_foreign');
		});
		Schema::table('contrats', function(Blueprint $table) {
			$table->dropForeign('contrats_matiere_id_foreign');
		});
		Schema::table('honoraire_professeur', function(Blueprint $table) {
			$table->dropForeign('honoraire_professeur_professeur_id_foreign');
		});
		Schema::table('honoraire_professeur', function(Blueprint $table) {
			$table->dropForeign('honoraire_professeur_honoraire_id_foreign');
		});
		Schema::table('achats', function(Blueprint $table) {
			$table->dropForeign('achats_forfait_id_foreign');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->dropForeign('medias_professeur_id_foreign');
		});
		Schema::table('horaireable', function(Blueprint $table) {
			$table->dropForeign('horaireable_horaire_id_foreign');
		});
		Schema::table('matiereable', function(Blueprint $table) {
			$table->dropForeign('matiereable_matiere_id_foreign');
		});
		Schema::table('honoraireable', function(Blueprint $table) {
			$table->dropForeign('honoraireable_honoraire_id_foreign');
		});
		Schema::table('mediasable', function(Blueprint $table) {
			$table->dropForeign('mediasable_media_id_foreign');
		});
		Schema::table('achat_eleve', function(Blueprint $table) {
			$table->dropForeign('achat_eleve_eleve_id_foreign');
		});
		Schema::table('achat_eleve', function(Blueprint $table) {
			$table->dropForeign('achat_eleve_achat_id_foreign');
		});
		Schema::table('honoraire_facture', function(Blueprint $table) {
			$table->dropForeign('honoraire_facture_honoraire_id_foreign');
		});
		Schema::table('honoraire_facture', function(Blueprint $table) {
			$table->dropForeign('honoraire_facture_honoraire_facture_id_foreign');
		});
		Schema::table('paiements', function(Blueprint $table) {
			$table->dropForeign('paiements_achat_id_foreign');
		});
		Schema::table('forfait_matiere', function(Blueprint $table) {
			$table->dropForeign('forfait_matiere_forfait_id_foreign');
		});
		Schema::table('forfait_matiere', function(Blueprint $table) {
			$table->dropForeign('forfait_matiere_matiere_id_foreign');
		});
		Schema::table('achat_horaire', function(Blueprint $table) {
			$table->dropForeign('achat_horaire_achat_id_foreign');
		});
		Schema::table('achat_horaire', function(Blueprint $table) {
			$table->dropForeign('achat_horaire_horaire_id_foreign');
		});
		Schema::table('dates', function(Blueprint $table) {
			$table->dropForeign('dates_matiere_id_foreign');
		});
	}
}