<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FacturesProfesseurs extends Eloquent {

	protected $table = 'factures_professeurs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function contrats()
	{
		return $this->belongsTo('App\Models\Contrats');
	}

	public function honoraires()
	{
		return $this->belongsToMany('App\Models\Honoraires');
	}

}