<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Products extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function images()
    {
        return $this->hasMany('ProductsImage');
    }

    public function messages()
    {
        return $this->hasMany('Messages');
    }

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

    public function category()
    {
        return $this->hasOne('Categories', 'category_id');
    }

}