<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStatsFlightTable extends Migration {

	public function up()
	{
		Schema::create('stats_flight', function(Blueprint $table) {
			$table->bigIncrements('flight_id');
			$table->integer('account_id')->unsigned();
			$table->string('callsign', 10);
			$table->decimal('pos_lat', 12,8);
			$table->decimal('pos_lon', 12,8);
			$table->smallInteger('altitude');
			$table->smallInteger('speed')->unsigned();
			$table->timestamp('connected_at');
			$table->timestamp('departed_at')->nullable();
			$table->timestamp('arrived_at')->nullable();
			$table->timestamp('disconnected_at')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('stats_flight');
	}
}