<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSkillsTable extends Migration {

	public function up()
	{
		Schema::create('skills', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->tinyInteger('standard')->unsigned()->default('1');
			$table->tinyInteger('spin')->unsigned()->default('1');
			$table->tinyInteger('pop')->unsigned()->default('1');
			$table->tinyInteger('front')->unsigned()->default('1');
			$table->tinyInteger('rear')->unsigned()->default('1');
			$table->tinyInteger('side')->unsigned()->default('1');
			$table->tinyInteger('scrabble')->unsigned()->default('1');
			$table->tinyInteger('drop')->unsigned()->default('1');
			$table->tinyInteger('punt')->unsigned()->default('1');
			$table->tinyInteger('grubber')->unsigned()->default('1');
			$table->tinyInteger('goal')->unsigned()->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('skills');
	}
}