<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Donation extends Eloquent {

	protected $table = 'donations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Clients()
	{
		return $this->belongsTo('Clients', 'client_id');
	}

	public function Notifications()
	{
		return $this->hasMany('Notifications');
	}

}