<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('password', 255);
			$table->enum('gender', array('male', 'female'));
			$table->date('birth_date');
			$table->integer('city_id')->unsigned();
			$table->integer('blood_type_id')->unsigned();
			$table->string('phone', 255);
			$table->date('last_donation');
			$table->tinyInteger('status');
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}