<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('forum_categories', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('forum_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('forum_categories', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('forum_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('forum_comments', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('forum_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('forum_comments', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('forum_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('forum_comments', function(Blueprint $table) {
			$table->foreign('thread_id')->references('id')->on('forum_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('forum_comments', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('forum_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('forum_groups', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('forum_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('forum_threads', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('forum_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('forum_threads', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('forum_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('forum_categories', function(Blueprint $table) {
			$table->dropForeign('forum_categories_group_id_foreign');
		});
		Schema::table('forum_categories', function(Blueprint $table) {
			$table->dropForeign('forum_categories_author_id_foreign');
		});
		Schema::table('forum_comments', function(Blueprint $table) {
			$table->dropForeign('forum_comments_group_id_foreign');
		});
		Schema::table('forum_comments', function(Blueprint $table) {
			$table->dropForeign('forum_comments_category_id_foreign');
		});
		Schema::table('forum_comments', function(Blueprint $table) {
			$table->dropForeign('forum_comments_thread_id_foreign');
		});
		Schema::table('forum_comments', function(Blueprint $table) {
			$table->dropForeign('forum_comments_author_id_foreign');
		});
		Schema::table('forum_groups', function(Blueprint $table) {
			$table->dropForeign('forum_groups_author_id_foreign');
		});
		Schema::table('forum_threads', function(Blueprint $table) {
			$table->dropForeign('forum_threads_group_id_foreign');
		});
		Schema::table('forum_threads', function(Blueprint $table) {
			$table->dropForeign('forum_threads_category_id_foreign');
		});
	}
}