<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAgentsTable extends Migration {

	public function up()
	{
		Schema::create('agents', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('firstName');
			$table->string('lastName');
			$table->string('matricule')->nullable();
			$table->string('email')->nullable();
			$table->string('image')->nullable();
			$table->integer('entity_id')->unsigned();
			$table->integer('qrcode_id')->unsigned();
			$table->timestamp('timestamps');
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('agents');
	}
}