<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Entity extends Eloquent {

	protected $table = 'entities';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'acronym');

	public function checkings()
	{
		return $this->hasMany('App\Models\Checking');
	}

	public function agents()
	{
		return $this->hasMany('App\Models\Agent');
	}

}