<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionTable extends Migration {

	public function up()
	{
		Schema::create('question', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->text('title')->index();
			$table->string('hint')->nullable();
			$table->text('explanation')->nullable();
			$table->string('referencematerial')->nullable();
			$table->string('imagepath')->nullable();
			$table->boolean('published')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('question');
	}
}