<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('category_question', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('question')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('category_question', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('question_quiz', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quiz')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('question_quiz', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('question')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('category_question', function(Blueprint $table) {
			$table->dropForeign('category_question_question_id_foreign');
		});
		Schema::table('category_question', function(Blueprint $table) {
			$table->dropForeign('category_question_category_id_foreign');
		});
		Schema::table('question_quiz', function(Blueprint $table) {
			$table->dropForeign('question_quiz_quiz_id_foreign');
		});
		Schema::table('question_quiz', function(Blueprint $table) {
			$table->dropForeign('question_quiz_question_id_foreign');
		});
	}
}