<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTurnoTable extends Migration {

	public function up()
	{
		Schema::create('turno', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('cronograma_id')->unsigned();
			$table->integer('contribuyente_id')->unsigned();
			$table->date('fecha');
			$table->time('hora');
			$table->boolean('sobreturno');
			$table->boolean('alta_contribuyente');
			$table->string('alta_legajo', 8)->nullable();
			$table->datetime('cancelado')->nullable();
			$table->boolean('cancelado_contribuyente')->nullable();
			$table->string('cancelado_legajo', 8)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('turno');
	}
}