<?php

namespace App\Moron\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Dependencia extends Eloquent {

	protected $table = 'dependencia';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function tramites()
	{
		return $this->hasMany('Tramite', 'dependencia_id');
	}

	public function usuarios()
	{
		return $this->hasMany('DependenciaUsuario', 'dependencia_id');
	}

}