<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticulosRealesTable extends Migration {

	public function up()
	{
		Schema::create('articulos_reales', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->integer('articulo_id')->unsigned();
			$table->integer('almacen_id')->unsigned();
			$table->integer('proveedor_id')->unsigned();
			$table->float('precio_coste')->default('0');
			$table->float('precio_porte')->default('0');
			$table->float('precio_recomendado')->default('0');
			$table->float('descuento')->default('0');
			$table->text('observaciones')->nullable();
			$table->bigInteger('padre_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('articulos_reales');
	}
}