<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProveedoresTable extends Migration {

	public function up()
	{
		Schema::create('proveedores', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('nombre_comercial');
			$table->string('nombre_fiscal');
			$table->string('nombre_contacto')->nullable();
			$table->string('identificador');
			$table->string('direccion_fiscal');
			$table->string('direccion_postal')->nullable();
			$table->string('poblacion');
			$table->string('codigo_postal');
			$table->string('pais_id')->nullable();
			$table->integer('provincia_id')->unsigned()->nullable();
			$table->string('telefono')->nullable();
			$table->string('telefono_almacen')->nullable();
			$table->string('fax')->nullable();
			$table->string('email')->nullable();
			$table->string('web')->nullable();
			$table->string('horario_pedidos')->nullable();
			$table->text('observaciones')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('proveedores');
	}
}