<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('customer_id', 'end_date', 'conditions');

    public function products()
    {
        return $this->belongsToMany('Product');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

}