<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'Products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('category_id', 'name', 'price', 'quantity', 'notes', 'image');

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

}