<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('first_name', 'last_name', 'name', 'email', 'mobile', 'company_name', 'company_site', 'activated', 'password');

    public function governorates()
    {
        return $this->belongsTo('Governorate', 'governorate_id');
    }

    public function orders()
    {
        return $this->hasMany('Order');
    }

}