<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('login', 50);
			$table->string('email', 255);
			$table->string('password', 255);
			$table->string('country_subdivision_code', 50);
			$table->string('city', 50)->nullable();
			$table->string('postalCode', 50)->nullable();
			$table->integer('role_id')->unsigned();
			$table->string('address', 50)->nullable();
			$table->string('phone', 50)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}