<?php

namespace App\Models;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('name', 'login', 'email', 'password', 'country_subdivision_code', 'city', 'postalCode', 'role_id', 'address', 'phone');
	protected $visible = array('name', 'login', 'email', 'password', 'country_subdivision_code', 'city', 'postalCode', 'role_id', 'address', 'phone');

	public function roles()
	{
		return $this->belongsTo('App\Models\Role');
	}

	public function clients()
	{
		return $this->hasOne('App\Models\Client', 'client_id');
	}

	public function employes()
	{
		return $this->hasOne('App\Models\Employe', 'employe_id');
	}

}