<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Category extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;
    protected $fillable = array('name_ar', 'name_en', 'parent_id', 'type', 'image');

    public function getProduct()
    {
        return $this->hasMany('Products');
    }

    public function getStores()
    {
        return $this->hasMany('Suppliers');
    }

    public function getSlider()
    {
        return $this->morphMany('Slider', 'getSliderable');
    }

}