<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class City extends Model 
{

    protected $table = 'cities';
    public $timestamps = true;
    protected $fillable = array('name_ar', 'name_en', 'charge_value', 'delivery_value');

    public function getCountry()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function getOrders()
    {
        return $this->hasMany('UsersAddresses');
    }

    public function getTowns()
    {
        return $this->hasMany('Towns');
    }

}