<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class UsersAddresses extends Model 
{

    protected $table = 'users_addresses';
    public $timestamps = true;
    protected $fillable = array('fullname', 'note', 'is_address', 'phone', 'postal_code', 'country_id', 'city_id', 'town_id', 'user_id');

    public function getProductOrder()
    {
        return $this->belongsToMany('Cart');
    }

    public function getCity()
    {
        return $this->belongsTo('City', 'city_id');
    }

    public function getCountry()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function getUser()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function getRatings()
    {
        return $this->morphMany('Ratings', 'getRate');
    }

}