<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Enrollment extends Eloquent {

	protected $table = 'enrollments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function course()
	{
		return $this->hasOne('Course', 'course_id');
	}

	public function payment()
	{
		return $this->hasOne('Payment', 'payment_id');
	}

}