<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BudgetPlan extends Model 
{

    protected $table = 'budget_plan';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('father_id');

    public function costs_center()
    {
        return $this->hasOne('App\CostsCenter');
    }

    public function year()
    {
        return $this->hasOne('App\Year');
    }

    public function rubro_type()
    {
        return $this->hasOne('App\RubroType');
    }

}