<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Users extends Model 
{

    protected $table = 'Users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('id_user', 'name', 'firstname', 'email', 'password');

    public function user_server()
    {
        return $this->hasMany('App\Server', 'id_server');
    }

}