<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBusinessTable extends Migration {

	public function up()
	{
		Schema::create('business', function(Blueprint $table) {
			$table->increments('business_id');
			$table->string('name');
			$table->string('image');
			$table->integer('category');
			$table->string('address');
			$table->string('phone');
			$table->string('postal_code');
			$table->float('x_coord', 10,6);
			$table->float('y_coord', 10,6);
			$table->float('score_average');
			$table->text('description');
			$table->string('website');
			$table->integer('base_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('business');
	}
}