<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('business', function(Blueprint $table) {
			$table->foreign('base_id')->references('base_id')->on('base')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('review', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('review', function(Blueprint $table) {
			$table->foreign('business_id')->references('business_id')->on('business')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->foreign('business_id')->references('business_id')->on('business')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('followers', function(Blueprint $table) {
			$table->foreign('userA_id')->references('user_id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('followers', function(Blueprint $table) {
			$table->foreign('userB_id')->references('user_id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('base_id')->references('base_id')->on('base')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('category', function(Blueprint $table) {
			$table->foreign('cat_id')->references('category')->on('business')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('owner', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('owner', function(Blueprint $table) {
			$table->foreign('business_id')->references('business_id')->on('business')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('business', function(Blueprint $table) {
			$table->dropForeign('business_base_id_foreign');
		});
		Schema::table('review', function(Blueprint $table) {
			$table->dropForeign('review_user_id_foreign');
		});
		Schema::table('review', function(Blueprint $table) {
			$table->dropForeign('review_business_id_foreign');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->dropForeign('favorites_business_id_foreign');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->dropForeign('favorites_user_id_foreign');
		});
		Schema::table('followers', function(Blueprint $table) {
			$table->dropForeign('followers_userA_id_foreign');
		});
		Schema::table('followers', function(Blueprint $table) {
			$table->dropForeign('followers_userB_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_base_id_foreign');
		});
		Schema::table('category', function(Blueprint $table) {
			$table->dropForeign('category_cat_id_foreign');
		});
		Schema::table('owner', function(Blueprint $table) {
			$table->dropForeign('owner_user_id_foreign');
		});
		Schema::table('owner', function(Blueprint $table) {
			$table->dropForeign('owner_business_id_foreign');
		});
	}
}