<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('straat', 255);
			$table->integer('huisnummer');
			$table->string('toevoeging', 31)->nullable();
			$table->string('postcode', 6);
			$table->string('plaats', 255);
			$table->boolean('factuuradres')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}