<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderLinesTable extends Migration {

	public function up()
	{
		Schema::create('order_lines', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->integer('inventory_id')->unsigned();
			$table->integer('address_id')->unsigned();
			$table->integer('location_id')->unsigned()->nullable();
			$table->enum('soort', array(''pickup'', ''return''));
			$table->enum('status', array(''));
			$table->decimal('prijs')->nullable();
			$table->date('datum')->nullable();
			$table->string('tijdblok')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('order_lines');
	}
}