<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uFirstName', 50);
			$table->string('uLastName', 100);
			$table->string('email', 100)->unique();
			$table->string('password', 255);
			$table->boolean('superAdmin')->default(false);
			$table->enum('active', array('True', 'False'));
			$table->rememberToken();
			$table->enum('Type', array('Doorknocker', 'Installer', 'Provider', 'Admin'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}