<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAnswersTable extends Migration {

	public function up()
	{
		Schema::create('answers', function(Blueprint $table) {
			$table->integer('id')->unsigned();
			$table->enum('predefined_ans', array('pre_defined_text', 'slider', 'free_type_text'));
			$table->integer('sliderStart')->nullable();
			$table->integer('sliderLength')->unsigned();
			$table->text('Answer');
			$table->integer('nextQuestionToShow');
			$table->integer('productsToShowFrom')->unsigned();
			$table->integer('productsToShowTo')->default('0');
			$table->enum('weaStatus', array('Active', 'Inactive'))->nullable();
			$table->bigInteger('surveyId')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('answers');
	}
}