<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('waterCustId')->unsigned();
			$table->date('appointmentDate');
			$table->smallInteger('appointmentSlot');
			$table->smallInteger('appointment_number')->nullable();
			$table->integer('installerId')->unsigned()->nullable();
			$table->enum('status', array('NotAssigned', 'InProgress', 'CallBack', 'Rejected', 'Aborted', 'Completed', 'Postcodenotconfirmed', 'Booked', 'Re-Booked1', 'Re-Booked2', 'Re-Booked3', 'Re-Booked4', 'Re-Booked5', 'Cancelled', 'InstallerAssigned', 'NoAnswer', 'Deleted', 'Missed', 'PendingToAcceptByInstaller'));
			$table->enum('contactPreference', array('Text', 'Email', 'Landline'));
			$table->enum('callReminderRequired', array('Yes', 'No'));
			$table->bigInteger('DoorKnockerId')->unsigned()->nullable()->index();
			$table->integer('surveyId')->nullable();
			$table->enum('channel', array('DoorKnocking', 'InboundCall', 'Employee', 'Website', 'Letter', 'Leaflet', 'Footfall', 'Coupon', 'Outbound', 'FieldEvent'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('bookings');
	}
}