<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Orders', function(Blueprint $table) {
			$table->foreign('customerId')->references('id')->on('waterCustomer')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Orders', function(Blueprint $table) {
			$table->foreign('productId')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('waterCustId')->references('id')->on('waterCustomer')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('installerId')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('DoorKnockerId')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Doorknocker', function(Blueprint $table) {
			$table->foreign('doorKnockerId')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Doorknocker', function(Blueprint $table) {
			$table->foreign('customerId')->references('id')->on('waterCustomer')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('surveyId')->references('surveyId')->on('bookings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Installers', function(Blueprint $table) {
			$table->foreign('installerId')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Installers', function(Blueprint $table) {
			$table->foreign('installerWorkPostId')->references('id')->on('workPostCodes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('answerPivot', function(Blueprint $table) {
			$table->foreign('questionId')->references('id')->on('questions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('Orders', function(Blueprint $table) {
			$table->dropForeign('Orders_customerId_foreign');
		});
		Schema::table('Orders', function(Blueprint $table) {
			$table->dropForeign('Orders_productId_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_waterCustId_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_installerId_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_DoorKnockerId_foreign');
		});
		Schema::table('Doorknocker', function(Blueprint $table) {
			$table->dropForeign('Doorknocker_doorKnockerId_foreign');
		});
		Schema::table('Doorknocker', function(Blueprint $table) {
			$table->dropForeign('Doorknocker_customerId_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_surveyId_foreign');
		});
		Schema::table('Installers', function(Blueprint $table) {
			$table->dropForeign('Installers_installerId_foreign');
		});
		Schema::table('Installers', function(Blueprint $table) {
			$table->dropForeign('Installers_installerWorkPostId_foreign');
		});
		Schema::table('answerPivot', function(Blueprint $table) {
			$table->dropForeign('answerPivot_questionId_foreign');
		});
	}
}