<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChannelsTable extends Migration {

	public function up()
	{
		Schema::create('channels', function(Blueprint $table) {
			$table->integer('c_id', true);
			$table->integer('a_id');
			$table->string('c_name', 100);
			$table->string('c_type', 20)->nullable();
			$table->integer('c_priority')->nullable();
			$table->integer('c_parent')->nullable();
			$table->text('c_settings')->nullable();
			$table->enum('c_unread_interval', array(''day'', ''2days'', ''7days'', ''28days''))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('channels');
	}
}