<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Addressbook extends Eloquent {

	protected $table = 'addressbook';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('parent_id');
	protected $fillable = array('address1', 'address2', 'address3', 'city', 'state', 'country', 'pincode', 'landmark');

	public function client()
	{
		return $this->belongsTo('Client', 'parent_id');
	}

	public function user()
	{
		return $this->belongsTo('App\User', 'parent_id');
	}

}