<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'shortname', 'supplier', 'manufacturer');

	public function addresses()
	{
		return $this->hasMany('App\Addressbook', 'parent_id');
	}

	public function contacts()
	{
		return $this->hasMany('Contact', 'client_id');
	}

	public function leads()
	{
		return $this->hasMany('App\Lead', 'client_id');
	}

	public function properties()
	{
		return $this->hasMany('App\ClientProperty', 'client_id');
	}

}